/*
chimer-1.1:

This is a Windows program that runs in the background and chimes every hour
as a 4-bit binary number through the internal speaker.

Copyright (C) 2005 Paul Marks

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 Temple
Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include <windows.h>

#define LEN 95
#define DELAY 75

long getremain();
int gethour();

int main(int argc, char *argv[])
{
    int freq[] = {850, 1350};
    long remain;
    int hour;
   
    // Prevent multiple instances
    CreateMutex(NULL, 1, "chimer-instance-mutex");
    if (GetLastError() == ERROR_ALREADY_EXISTS) return 1;
    
    // Loop forever
    for(;;)
    {
        // Wait until the next hour
        while ((remain = getremain()) != 0)
        {
            // Sleep for half the remaining time
            // (Gets more precise as the hour draws nearer)
            Sleep(remain);
        }

        // Play the binary chime
        hour = gethour();
        Beep(freq[(hour&8)>>3], LEN);
        Sleep(DELAY);
        Beep(freq[(hour&4)>>2], LEN);
        Sleep(DELAY);
        Beep(freq[(hour&2)>>1], LEN);
        Sleep(DELAY);
        Beep(freq[(hour&1)>>0], LEN);
        
        // Wait a sec so we're not still at :00:00
        Sleep(1000);
    }
    
    return 0;
}

long getremain()
{
    // return half the remaining time to the next hour, in milliseconds
    // Returns 0 if we're at :00:00
    SYSTEMTIME st;
    long remain;
    GetLocalTime(&st);
    if (st.wMinute == 0 && st.wSecond == 0) return 0;
    remain = (60*60*1000 - (st.wMinute*60000 + st.wSecond*1000 + st.wMilliseconds)) / 2;
    return (remain > 0) ? remain : 1;
}

int gethour()
{
    // return the current hour 1..12
    SYSTEMTIME st;
    int hour;
    GetLocalTime(&st);
    hour = st.wHour % 12;
    return (hour != 0) ? hour : 12;
}
