Attribute VB_Name = "modCode"
Option Explicit
Public sngCodeNum As Single
Public bytCryptMode As Byte

Public Const ENCRYPT As Byte = 1
Public Const DECRYPT As Byte = 2
Public Const CHANGE_MODE As Byte = 3
Public Const ASC_TO_B64 As Byte = 4
Public Const B64_TO_ASC As Byte = 5
Public Const LIT_COLOR As Long = &HFF00&
Public Const DIM_COLOR As Long = &H8000&
Public Const B64 As String = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz1234567890!?"

Function Base64(ByVal strInput As String, ByVal bytDirection As Byte) As String
    Dim i As Integer, j As Integer
    Dim dblGrpVal As Double
    Dim bytTemp
    Dim intLength As Integer
    Dim strOut As String
    
    strOut = ""
    
    Select Case bytDirection
        Case ASC_TO_B64
            intLength = 3 - (Len(strInput) Mod 3)
            If intLength = 3 Then intLength = 0
            strInput = strInput + String(intLength, 0)
            
            intLength = Len(strInput)
            
            For i = 1 To intLength Step 3
                dblGrpVal = 0
                
                For j = 0 To 2
                    dblGrpVal = dblGrpVal + Asc(Mid(strInput, i + j)) * 256 ^ (2 - j)
                Next j
                
                For j = 3 To 0 Step -1
                    bytTemp = (dblGrpVal And 63 * 64 ^ j) / 64 ^ j
                    strOut = strOut + Mid(B64, bytTemp + 1, 1)
                Next j
            Next i
        
        Case B64_TO_ASC
            intLength = Len(strInput)
            For i = 1 To intLength Step 4
                dblGrpVal = 0
                
                For j = 0 To 3
                    bytTemp = InStr(B64, Mid(strInput, i + j, 1)) - 1
                    dblGrpVal = dblGrpVal + (bytTemp * 64 ^ (3 - j))
                Next j

                For j = 2 To 0 Step -1
                    bytTemp = (dblGrpVal And 255 * 256 ^ j) / 256 ^ j
                    If intLength - i > 3 Or bytTemp > 0 Then
                        strOut = strOut + Chr(bytTemp)
                    End If
                Next j
            Next i
    End Select
    
    Base64 = strOut
End Function

Function Crypter(ByVal strWhat As String, ByVal bytDirection As Byte, ByVal sngCodeNum As Single) As String
    If sngCodeNum = -1 Then
        Crypter = "Invalid Code Number"
    Else
        Dim i As Integer
        Dim strOut As String
        Dim sngSeed As Single
        Dim intChr As Integer
        Dim intDir As Integer
        Dim bytBaseDir As Integer
        
        sngSeed = -Abs(sngCodeNum)
        
        Select Case bytDirection
            Case ENCRYPT: intDir = 1
            Case DECRYPT
                intDir = -1
                strWhat = Base64(strWhat, B64_TO_ASC)
        End Select
        
        strOut = ""
        
        For i = 1 To Len(strWhat)
            intChr = Asc(Mid(strWhat, i, 1)) + (Int(Rnd(sngSeed) * 128) * intDir)
            If intChr < 0 Then intChr = intChr + 256
            If intChr > 255 Then intChr = intChr - 256
            strOut = strOut + Chr(intChr)
            sngSeed = -Abs(Rnd(sngSeed) * 32000)
        Next i
        
        If bytDirection = ENCRYPT Then strOut = Base64(strOut, ASC_TO_B64)
        Crypter = strOut
    End If
End Function

Sub SelectAll(objWhat As Object)
    objWhat.SelStart = 0
    objWhat.SelLength = Len(objWhat.Text)
End Sub

Sub Main()
    Randomize Timer
    frmMain.Show
End Sub
