Attribute VB_Name = "modCode"
Declare Function GetPixel Lib "gdi32.dll" (ByVal hdc As Long, ByVal nXPos As Long, ByVal nYPos As Long) As Long
Declare Function SetPixelV Lib "gdi32.dll" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal crColor As Long) As Long
Declare Function BitBlt Lib "gdi32.dll" (ByVal hdcDest As Long, ByVal nXDest As Long, ByVal nYDest As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hdcSrc As Long, ByVal nXSrc As Long, ByVal nYSrc As Long, ByVal dwRop As Long) As Long

Public Const SRCCOPY = &HCC0020
Public Const NOTSRCCOPY = &H330008

Function ColorToBW(lngRGB As Long) As Long
    Dim intBright As Integer
    intBright = ((lngRGB And &HFF0000) / &H10000 + (lngRGB And &HFF00&) / &H100& + (lngRGB And &HFF&))
    If intBright < 383 Then ColorToBW = 1 Else ColorToBW = 0
End Function

Sub SelectAll(objTextBox As Object)
    objTextBox.SelStart = 0
    objTextBox.SelLength = Len(objTextBox.Text)
End Sub

Function RLE(strData As String) As String
    Const RLE_KEY = &H91
    Dim strRLE As String
    Dim lngDatLen As Long
    Dim lngPos As Long
    Dim intStartChr As Integer
    Dim intTestChr As Integer
    Dim intRunLen As Integer

    If strData <> "" Then
        lngDatLen = Len(strData)
        lngPos = 1
        Do
            intStartChr = Asc(Mid(strData, lngPos, 1))
            intRunLen = 0
            
            Do
                intRunLen = intRunLen + 1
                If lngPos + intRunLen > lngDatLen Then
                    intTestChr = 300    'will never match
                Else
                    intTestChr = Asc(Mid(strData, lngPos + intRunLen, 1))
                End If
            Loop While (intRunLen < 256) And (intTestChr = intStartChr)
            
            If (intRunLen > 3) Or (intStartChr = RLE_KEY) Then
                strRLE = strRLE & Chr(RLE_KEY) & Chr(intStartChr) & Chr(IIf(intRunLen = 256, 0, intRunLen))
            Else
                strRLE = strRLE & String(intRunLen, intStartChr)
            End If
            
            lngPos = lngPos + intRunLen
        Loop Until lngPos > lngDatLen
    End If
    RLE = strRLE
End Function

Sub Add(ByRef Var1, Optional ByVal Var2 = 1)
    Var1 = Var1 + Var2
End Sub

Sub Center(objNew As Object, objParent As Object)
    objNew.Left = ((objParent.Width - objNew.Width) / 2) + objParent.Left
    objNew.Top = ((objParent.Height - objNew.Height) / 2) + objParent.Top
End Sub
