VERSION 5.00
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "SpriteMaster"
   ClientHeight    =   4980
   ClientLeft      =   150
   ClientTop       =   720
   ClientWidth     =   7845
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   332
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   523
   StartUpPosition =   3  'Windows Default
   Begin VB.PictureBox picBuffer 
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BackColor       =   &H00808080&
      BorderStyle     =   0  'None
      Height          =   240
      Left            =   4800
      ScaleHeight     =   16
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   24
      TabIndex        =   23
      Top             =   1920
      Visible         =   0   'False
      Width           =   360
   End
   Begin VB.Frame Frame4 
      Caption         =   "Output"
      Height          =   4815
      Left            =   3000
      TabIndex        =   18
      Top             =   0
      Width           =   4695
      Begin VB.CommandButton cmdCopy 
         Caption         =   "Copy Text To Clipboard"
         Height          =   375
         Left            =   120
         TabIndex        =   11
         Top             =   4320
         Width           =   4455
      End
      Begin VB.TextBox txtWrapPt 
         Alignment       =   2  'Center
         Height          =   285
         Left            =   2040
         MaxLength       =   3
         TabIndex        =   10
         Text            =   "12"
         Top             =   240
         Width           =   495
      End
      Begin VB.TextBox txtPreview 
         BeginProperty Font 
            Name            =   "Terminal"
            Size            =   6
            Charset         =   255
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   3615
         Left            =   120
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         ScrollBars      =   3  'Both
         TabIndex        =   19
         TabStop         =   0   'False
         Top             =   600
         Width           =   4455
      End
      Begin VB.Label lblDataSize 
         Alignment       =   1  'Right Justify
         Caption         =   "Data Size: 1024 bytes"
         Height          =   255
         Left            =   2760
         TabIndex        =   21
         Top             =   240
         Width           =   1815
      End
      Begin VB.Label Label10 
         Caption         =   "Maximum Elements / Line:"
         Height          =   255
         Left            =   120
         TabIndex        =   20
         Top             =   240
         Width           =   1935
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Image"
      Height          =   1935
      Left            =   120
      TabIndex        =   17
      Top             =   0
      Width           =   2775
      Begin VB.TextBox txtClip 
         Height          =   285
         Index           =   1
         Left            =   2040
         MaxLength       =   3
         TabIndex        =   2
         Top             =   720
         Width           =   495
      End
      Begin VB.TextBox txtClip 
         Height          =   285
         Index           =   0
         Left            =   1200
         MaxLength       =   3
         TabIndex        =   1
         Top             =   720
         Width           =   495
      End
      Begin VB.ComboBox cboInvert 
         Height          =   315
         ItemData        =   "frmMain.frx":0212
         Left            =   1200
         List            =   "frmMain.frx":021C
         Style           =   2  'Dropdown List
         TabIndex        =   3
         Top             =   1080
         Width           =   1335
      End
      Begin VB.ComboBox cboBGColor 
         Height          =   315
         ItemData        =   "frmMain.frx":0229
         Left            =   1200
         List            =   "frmMain.frx":0233
         Style           =   2  'Dropdown List
         TabIndex        =   4
         Top             =   1440
         Width           =   1335
      End
      Begin VB.CommandButton cmdPaste 
         Caption         =   "Paste From Clipboard"
         Height          =   375
         Left            =   120
         TabIndex        =   0
         Top             =   240
         Width           =   2415
      End
      Begin VB.Label Label4 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "x"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   240
         Left            =   1920
         TabIndex        =   27
         Top             =   720
         Width           =   90
      End
      Begin VB.Label Label5 
         Caption         =   "Sprite Size:"
         Height          =   255
         Left            =   120
         TabIndex        =   26
         Top             =   720
         Width           =   975
      End
      Begin VB.Label Label1 
         Caption         =   "Invert:"
         Height          =   255
         Left            =   120
         TabIndex        =   25
         Top             =   1080
         Width           =   975
      End
      Begin VB.Label Label2 
         Caption         =   "Padding:"
         Height          =   255
         Left            =   120
         TabIndex        =   24
         Top             =   1440
         Width           =   975
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Output Format"
      Height          =   2775
      Left            =   120
      TabIndex        =   12
      Top             =   2040
      Width           =   2775
      Begin VB.ComboBox cboRowPrefix 
         Height          =   315
         ItemData        =   "frmMain.frx":0245
         Left            =   1200
         List            =   "frmMain.frx":0252
         TabIndex        =   9
         Top             =   2280
         Width           =   1335
      End
      Begin VB.ComboBox cboTxtFormat 
         Height          =   315
         ItemData        =   "frmMain.frx":027A
         Left            =   1200
         List            =   "frmMain.frx":0284
         Style           =   2  'Dropdown List
         TabIndex        =   8
         Top             =   1800
         Width           =   1335
      End
      Begin VB.ComboBox cboRle 
         Height          =   315
         ItemData        =   "frmMain.frx":0293
         Left            =   1200
         List            =   "frmMain.frx":029D
         Style           =   2  'Dropdown List
         TabIndex        =   6
         Top             =   840
         Width           =   1335
      End
      Begin VB.ComboBox cboByteOrder 
         Height          =   315
         ItemData        =   "frmMain.frx":02AA
         Left            =   1200
         List            =   "frmMain.frx":02B4
         Style           =   2  'Dropdown List
         TabIndex        =   5
         Top             =   360
         Width           =   1335
      End
      Begin VB.ComboBox cboRadix 
         Height          =   315
         ItemData        =   "frmMain.frx":02CE
         Left            =   1200
         List            =   "frmMain.frx":02DB
         Style           =   2  'Dropdown List
         TabIndex        =   7
         Top             =   1320
         Width           =   1335
      End
      Begin VB.Label Label9 
         Caption         =   "Row Prefix:"
         Height          =   255
         Left            =   120
         TabIndex        =   22
         Top             =   2280
         Width           =   975
      End
      Begin VB.Label Label3 
         Caption         =   "Byte Order:"
         Height          =   255
         Left            =   120
         TabIndex        =   16
         Top             =   360
         Width           =   975
      End
      Begin VB.Label Label6 
         Caption         =   "RLE:"
         Height          =   255
         Left            =   120
         TabIndex        =   15
         Top             =   840
         Width           =   975
      End
      Begin VB.Label Label7 
         Caption         =   "Num Format:"
         Height          =   255
         Left            =   120
         TabIndex        =   14
         Top             =   1800
         Width           =   975
      End
      Begin VB.Label Label8 
         Caption         =   "Radix:"
         Height          =   255
         Left            =   120
         TabIndex        =   13
         Top             =   1320
         Width           =   975
      End
   End
   Begin VB.Menu mnuMenu 
      Caption         =   "&Menu"
      Begin VB.Menu mnuPaste 
         Caption         =   "&Paste Image"
      End
      Begin VB.Menu mnuCopy 
         Caption         =   "&Copy Text"
      End
      Begin VB.Menu Hyphen1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuAbout 
      Caption         =   "&About"
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim intBitNum As Integer
Dim bytCurByte As Byte
Dim strPicData As String

Private Sub cboBGColor_Click()
    RefreshPicture
End Sub

Private Sub cboByteOrder_Click()
    DumpPictureData True
End Sub

Private Sub cboInvert_Click()
    RefreshPicture
End Sub

Private Sub cboRadix_Click()
    Dim intIndex As Integer
    
    intIndex = cboTxtFormat.ListIndex
    
    Do While cboTxtFormat.ListCount <> 0
        cboTxtFormat.RemoveItem 0
    Loop
    
    Select Case cboRadix.ListIndex
        Case 0
            cboTxtFormat.AddItem "%01010101"
            cboTxtFormat.AddItem "01010101b"
            cboTxtFormat.AddItem "0b01010101"
        Case 1
            cboTxtFormat.AddItem "$FF"
            cboTxtFormat.AddItem "0FFh"
            cboTxtFormat.AddItem "0xFF"
        Case 2:
            cboTxtFormat.AddItem "123"
    End Select
    
    If intIndex > cboTxtFormat.ListCount - 1 Then intIndex = cboTxtFormat.ListCount - 1
    cboTxtFormat.ListIndex = intIndex
    
    DumpPictureData
End Sub

Private Sub cboRle_Click()
    DumpPictureData True
End Sub

Private Sub cboRowPrefix_Click()
    DumpPictureData
End Sub

Private Sub cboRowPrefix_GotFocus()
    SelectAll cboRowPrefix
End Sub

Private Sub cboRowPrefix_KeyPress(KeyAscii As Integer)
    If KeyAscii = 13 Then
        KeyAscii = 0
        DumpPictureData
    End If
End Sub

Private Sub cboRowPrefix_LostFocus()
    DumpPictureData
End Sub

Private Sub cboTxtFormat_Click()
    DumpPictureData
End Sub

Sub PasteImage()
    Dim x As Long, intPicX As Long
    Dim y As Long, intPicY As Long
    If Clipboard.GetFormat(vbCFBitmap) Then
        With picBuffer
            .Picture = Clipboard.GetData
            intPicX = .ScaleWidth
            intPicY = .ScaleHeight
            If intPicX > 240 Then intPicX = 240
            If intPicY > 128 Then intPicY = 128
            For y = 0 To intPicY - 1
                For x = 0 To intPicX - 1
                    SetPixelV .hdc, x, y, (1 - ColorToBW(GetPixel(.hdc, x, y))) * vbWhite
                Next x
            Next y
            txtClip(0).Text = intPicX
            txtClip(1).Text = intPicY
            RefreshPicture
        End With
    Else
        MsgBox "Clipboard does not contain a bitmap.", vbExclamation, "Error"
    End If
End Sub

Sub RefreshPicture()
    Dim lngMethod As Long
    Dim lngBGColor As Long
    Dim intX As Integer, intY As Integer
    Dim strText As String
    
    Dim intLeft As Integer
    Dim intTop As Integer
   
    FixClips intX, intY
    
    If picBuffer.Picture <> 0 Then
        If cboBGColor.ListIndex = 0 Then
            lngBGColor = vbWhite
        Else
            lngBGColor = vbBlack
        End If
        If cboInvert.ListIndex = 0 Then
            lngMethod = SRCCOPY
        Else
            lngMethod = NOTSRCCOPY
        End If
        frmSprite.Cls
        frmSprite.Line (0, 0)-(intX - 1, intY - 1), lngBGColor, BF
        BitBlt frmSprite.hdc, 0, 0, Val(txtClip(0).Text), intY, picBuffer.hdc, 0, 0, lngMethod
        frmSprite.Visible = True
        frmSprite.Refresh
        DumpPictureData True
    End If
End Sub

Sub DumpPictureData(Optional blnReRead As Boolean = False)
    Dim intPicX As Integer, intPicY As Integer
    Dim x As Integer, y As Integer, b As Integer
    
    Dim strText As String
    Dim intCurCol As Integer
    Dim lngRowWidth As Long
    Dim lngFromLeft As Long
    Dim i As Long
    
    FixClips intPicX, intPicY
    
    If blnReRead Then
        strPicData = ""
        intBitNum = 7
        bytCurByte = 0
        
        If cboByteOrder.ListIndex = 0 Then
            For y = 0 To intPicY - 1
            For x = 0 To intPicX - 1
                AddPixelToPicData x, y
            Next x, y
        Else
            For x = 0 To intPicX - 1 Step 8
            For y = 0 To intPicY - 1
            For b = 0 To 7
                AddPixelToPicData x + b, y
            Next b, y, x
        End If
        
        If cboRle.ListIndex = 1 Then
            strPicData = RLE(strPicData)
        End If
    End If
    
    If cboRle.ListIndex = 1 Then
        lngRowWidth = Len(strPicData)
    Else
        If cboByteOrder.ListIndex = 0 Then
            lngRowWidth = intPicX / 8
        Else
            lngRowWidth = intPicY
        End If
    End If
    
    intCurCol = 0
    lngFromLeft = 0
    For i = 1 To Len(strPicData)
        If intCurCol = 0 Then
            Add strText, Replace(cboRowPrefix.Text, "<t>", vbTab)
        End If
        Add strText, ByteToText(Asc(Mid(strPicData, i, 1)))
        Add lngFromLeft
        Add intCurCol
        If lngFromLeft = lngRowWidth Then lngFromLeft = 0: intCurCol = 0
        If intCurCol = Val(txtWrapPt.Text) Then intCurCol = 0
        If intCurCol > 0 Then Add strText, "," Else Add strText, vbCrLf
    Next i
    txtPreview.Text = strText
    lblDataSize.Caption = "Data Size: " & Len(strPicData) & " bytes"
End Sub

Sub AddPixelToPicData(intX As Integer, intY As Integer)
    Add bytCurByte, ColorToBW(GetPixel(frmSprite.hdc, intX, intY)) * 2 ^ intBitNum
    Add intBitNum, -1
    If intBitNum = -1 Then
        Add strPicData, Chr(bytCurByte)
        intBitNum = 7
        bytCurByte = 0
    End If
End Sub

Function ByteToText(intByte As Integer) As String
    Dim strOut As String
    Dim i As Integer
    
    Select Case cboRadix.ListIndex
        Case 0
            For i = 7 To 0 Step -1
                Add strOut, IIf((intByte And 2 ^ i) = 0, "0", "1")
            Next i
            Select Case cboTxtFormat.ListIndex
                Case 0
                    strOut = "%" & strOut
                Case 1
                    Add strOut, "b"
                Case 2
                    strOut = "0b" & strOut
            End Select
        Case 1
            strOut = Hex(intByte)
            If intByte <= &HF Then strOut = "0" & strOut
            Select Case cboTxtFormat.ListIndex
                Case 0
                    strOut = "$" & strOut
                Case 1
                    If intByte > &H99 Then strOut = "0" & strOut
                    Add strOut, "h"
                Case 2
                    strOut = "0x" & strOut
            End Select
        Case 2
            strOut = Trim(Str(intByte))
    End Select
    ByteToText = strOut
End Function

Private Sub cmdCopy_Click()
    Clipboard.Clear
    Clipboard.SetText txtPreview.Text, vbCFText
End Sub

Private Sub cmdPaste_Click()
    PasteImage
End Sub

Private Sub Form_Load()
    frmSprite.Show
    cboBGColor.ListIndex = 0
    cboInvert.ListIndex = 0
    cboByteOrder.ListIndex = 0
    cboRle.ListIndex = 0
    cboRadix.ListIndex = 0
    cboTxtFormat.ListIndex = 0
    cboRowPrefix.ListIndex = 0
End Sub

Sub FixClips(ByRef x As Integer, ByRef y As Integer)
    x = Val(txtClip(0).Text)
    y = Val(txtClip(1).Text)
    If x < 1 Then x = 1
    If x > 999 Then x = 999
    If y < 1 Then y = 1
    If y > 999 Then y = 999
    txtClip(0).Text = x
    txtClip(1).Text = y
    If x Mod 8 <> 0 Then x = x + 8 - (x Mod 8)
End Sub

Private Sub hsbPic_Change()
    RefreshPicture
End Sub

Private Sub hsbPic_Scroll()
    RefreshPicture
End Sub

Private Sub Form_Unload(Cancel As Integer)
    End
End Sub

Private Sub mnuAbout_Click()
    frmAbout.Show 1
End Sub

Private Sub mnuCopy_Click()
    cmdCopy_Click
End Sub

Private Sub mnuExit_Click()
    End
End Sub

Private Sub mnuPaste_Click()
    PasteImage
End Sub

Private Sub txtClip_GotFocus(Index As Integer)
    SelectAll txtClip(Index)
End Sub

Private Sub txtClip_KeyPress(Index As Integer, KeyAscii As Integer)
    If KeyAscii = 13 Then
        KeyAscii = 0
        RefreshPicture
    End If
End Sub

Private Sub txtClip_LostFocus(Index As Integer)
    RefreshPicture
End Sub

Private Sub txtWrapPt_GotFocus()
    SelectAll txtWrapPt
End Sub

Private Sub txtWrapPt_KeyPress(KeyAscii As Integer)
    If KeyAscii = 13 Then
        KeyAscii = 0
        txtWrapPt_LostFocus
    End If
End Sub

Private Sub txtWrapPt_LostFocus()
    Dim intNum As Integer
    txtWrapPt.Text = Val(txtWrapPt.Text)
    DumpPictureData
End Sub

Private Sub vsbPic_Change()
    RefreshPicture
End Sub

Private Sub vsbPic_Scroll()
    RefreshPicture
End Sub
