Attribute VB_Name = "modCode"
Option Explicit
Public Const TITLE = "PeSHyTalk"
Public Const VER = "1.14"


Public Type CHOOSECOLOR
    lStructSize As Long
    hwndOwner As Long
    hInstance As Long
    rgbResult As Long
    lpCustColors As String
    flags As Long
    lCustData As Long
    lpfnHook As Long
    lpTemplateName As String
End Type

Public udtColor As CHOOSECOLOR
Public Declare Function ShowColor Lib "comdlg32.dll" Alias "ChooseColorA" (pChoosecolor As CHOOSECOLOR) As Long

Public Const MSG_LOGIN = "L"
Public Const MSG_NORMAL = "N"
Public Const MSG_EXIT = "X"
Public Const MSG_ACK = "A"

Public Const REG1 = "Paul248"
Public Const REG2 = "PeSHyTalk"

Public Const D_COL = 0
Public Const D_NAME = "<No Reply>"

Public Const COL = "C"
Public Const B_ON = "B"
Public Const B_OFF = "b"
Public Const LF = "<"

Public Const TMR_DELAY = 300

Type NodeStruc
    Use As Boolean
    IP As String
    Name As String
End Type

Public strLocIP As String
Public strName As String
Public udtNodes() As NodeStruc
Public DIV As String * 1
Public RTF As String * 1
Public SYS_MSG As String

Public strStates(0 To 12) As String
Public strChat As String
Public strColTbl() As String
Public lngNameCol As Long
Public lngTextCol As Long
Public blnFirst As Boolean
Public intTimer As Integer
Public strGCMode As String

Public lngIPUpCol As Long
Public Const lngIPDnCol As Long = &HC0FFC0


Function MakeRTF(strRaw As String) As String
    Dim i As Long, strParsed As String, lngLen As Long
    Dim strChar As String

    lngLen = Len(strRaw)
    For i = 1 To lngLen
        strChar = Mid(strRaw, i, 1)
        If strChar = RTF Then
            Add i
            strChar = Mid(strRaw, i, 1)
            Select Case strChar
                Case COL
                    Dim strColor As String
                    Add strParsed, "\cf" & ColTbl_Add(Mid(strRaw, i + 1, 6)) & " "
                    Add i, 6
                Case B_ON
                    Add strParsed, "\b "
                Case B_OFF
                    Add strParsed, "\b0 "
                Case LF
                    Add strParsed, "\par "
            End Select
        Else
            If InStr("{ }\;1234567890", strChar) <> 0 Then Add strParsed, "\"
            Add strParsed, strChar
        End If
    Next i
    MakeRTF = strParsed
End Function

Sub AddToRTF(strText As String)
    Add strChat, MakeRTF(strText)
    frmMain.rtfChat.TextRTF = "{\rtf1\ansi\ansicpg1252\deff0\deflang1033{\fonttbl{\f0\fnil\fprq2\fcharset0 MS Sans Serif;}}{\colortbl;" & ColTbl_Build & "}\f0\fs8\cf0\b0 " & strChat & "}"
End Sub

Sub Main()
    DIV = Chr(1)
    RTF = Chr(2)
    
    With udtColor
        .lpCustColors = String(64, 128)
        .flags = cdlCCRGBInit Or cdlCCFullOpen
    End With
    
    intTimer = TMR_DELAY
    
    strStates(icNone) = "(...)"
    strStates(icResolvingHost) = "Resolving Host..."
    strStates(icHostResolved) = "Host Resolved"
    strStates(icConnecting) = "Connecting to Host..."
    strStates(icConnected) = "Connected"
    strStates(icRequesting) = "Sending Request..."
    strStates(icRequestSent) = "Request Sent"
    strStates(icReceivingResponse) = "Receiving Response..."
    strStates(icResponseReceived) = "Response Received"
    strStates(icDisconnecting) = "Disconnecting..."
    strStates(icDisconnected) = "Disconnected"
    strStates(icError) = "Error!"
    strStates(icResponseCompleted) = "Response Completed"

    ReDim udtNodes(-1 To -1)
    ColTbl_Clear
   
    SYS_MSG = R(LF) & R(B_ON) & HexCol(0) & "> "
    
    strGCMode = MSG_LOGIN
    
    frmConnect.Show
End Sub

Sub SelectAll(objTextBox As Object)
    objTextBox.SelStart = 0
    objTextBox.SelLength = Len(objTextBox.Text)
End Sub

Sub Add(ByRef Var1 As Variant, Optional ByRef Var2 As Variant = 1)
    Var1 = Var1 + Var2
End Sub

Sub NodeList_Add(strIP As String, strName As String)
    Dim intMax As Integer
    Dim i As Integer
    Dim intIdx As Integer
    
    intIdx = NodeList_Find(strIP)
    If intIdx <> -1 Then
        If strName <> D_NAME Then udtNodes(intIdx).Name = strName
        udtNodes(intIdx).Use = True
    Else
        intMax = UBound(udtNodes) + 1
        ReDim Preserve udtNodes(-1 To intMax)
        With udtNodes(intMax)
            .IP = strIP
            .Name = strName
            .Use = True
        End With
    End If
End Sub

Function NodeList_Find(strIP As String) As Integer
    Dim i As Integer
    Dim intMax As Integer
    
    intMax = UBound(udtNodes)
    For i = 0 To intMax
        If udtNodes(i).IP = strIP Then
            NodeList_Find = i
            Exit Function
        End If
    Next i
    
    NodeList_Find = -1
End Function

Function NodeList_NameCollide(strName As String) As Boolean
    Dim i As Integer
    Dim intMax As Integer
    
    intMax = UBound(udtNodes)
    For i = 0 To intMax
        With udtNodes(i)
            If .Name = strName And .IP <> strLocIP Then
                NodeList_NameCollide = True
                Exit Function
            End If
        End With
    Next i
End Function

Sub NodeList_Remove(strIP As String)
    Dim intIdx As Integer
    Dim intMax As Integer
    intMax = UBound(udtNodes)
    intIdx = NodeList_Find(strIP)
    If intIdx <> -1 Then
        udtNodes(intIdx) = udtNodes(intMax)
        ReDim Preserve udtNodes(-1 To intMax - 1)
    End If
End Sub

Sub NodeList_Display()
    Dim i As Integer
    Dim intMax As Integer
    Dim blnFlag As Integer
    Dim udtSwap As NodeStruc
    
    intMax = UBound(udtNodes)
    Do
        For i = 0 To intMax - 1
            blnFlag = False
            If UCase(udtNodes(i).Name) > UCase(udtNodes(i + 1).Name) Then
                udtSwap = udtNodes(i)
                udtNodes(i) = udtNodes(i + 1)
                udtNodes(i + 1) = udtSwap
                blnFlag = True
            End If
        Next i
    Loop Until blnFlag = False

    With frmMain
        ClearListBox .lstNodes
        
        For i = 0 To intMax
            .lstNodes.AddItem udtNodes(i).Name
        Next i
        
        If (.lstNodes.ListIndex = -1) And (intMax >= 0) Then .lstNodes.ListIndex = 0
    End With
End Sub

Sub GetCache()
    With frmMain
        .netCache.Cancel
        ClearListBox .lstCacheStat
        .lstCacheStat.AddItem "Cache Update: Mode " & strGCMode
        .netCache.Execute , "POST", "ip=" & strLocIP & "&mode=" & strGCMode, "Content-Type: application/x-www-form-urlencoded"
    End With
End Sub

Sub ClearListBox(objListBox As Object)
    Dim i As Integer
    For i = 1 To objListBox.ListCount
        objListBox.RemoveItem 0
    Next i
End Sub

Sub IncomingMsg(strIncType As String, strIncIP As String, strIncName As String, strIncText As String)
    Select Case strIncType
        Case MSG_NORMAL
            If udtNodes(NodeList_Find(strIncIP)).Name <> strIncName Then
                NodeList_Add strIncIP, strIncName
                NodeList_Display
            End If
            AddToRTF strIncText
        
        Case MSG_EXIT
            NodeList_Remove strIncIP
            NodeList_Display
            AddToRTF strIncText
        
        Case MSG_LOGIN
            NodeList_Add strIncIP, strIncName
            NodeList_Display
            AddToRTF strIncText
            Broadcast MSG_ACK, strLocIP, strName, strIncIP
        
        Case MSG_ACK
            NodeList_Add strIncIP, strIncName
            NodeList_Display
            If NodeList_NameCollide(strName) Then
                MsgBox "Username Collision! Choose a New Name.", vbExclamation, "Error"
                frmMain.mnuChange_Click
            End If
                
    End Select
End Sub

Sub ColTbl_Clear()
    ReDim strColTbl(0 To 0)
    strColTbl(0) = "\red0\green0\blue0;"
End Sub

Function ColTbl_Add(strRGB As String) As String
    Dim intMax As Integer
    Dim i As Integer
    Dim strColor As String
    
    strColor = "\red" & Val("&H" & Mid(strRGB, 1, 2)) & _
        "\green" & Val("&H" & Mid(strRGB, 3, 2)) & _
        "\blue" & Val("&H" & Mid(strRGB, 5, 2)) & ";"

    intMax = UBound(strColTbl)
    For i = 0 To intMax
        If strColTbl(i) = strColor Then
            ColTbl_Add = i
            Exit Function
        End If
    Next i

    Add intMax

    ReDim Preserve strColTbl(0 To intMax)
    strColTbl(intMax) = strColor
    ColTbl_Add = intMax
    
End Function

Function ColTbl_Build() As String
    Dim intMax As Integer
    Dim i As Integer
    Dim strOut As String
    intMax = UBound(strColTbl)
    
    For i = 1 To intMax
        Add strOut, strColTbl(i)
    Next i
    ColTbl_Build = strOut
End Function

Function R(strAdd As String) As String
    R = RTF & strAdd
End Function

Sub ProcessNodes(strList As String)
    Dim i As Integer
    Dim strChar As String
    Dim strIP As String
    Dim intStrPart As Integer
    Dim intMax As Integer
    
    intMax = UBound(udtNodes)
    For i = 0 To intMax
        udtNodes(i).Use = False
    Next i
    
    ClearListBox frmMain.lstNodes
    
    intStrPart = 1
    For i = 1 To Len(strList)
        strChar = Mid(strList, i, 1)
        Select Case strChar
            Case "|"
                NodeList_Add strIP, D_NAME
                strIP = ""
            Case Else
                Add strIP, strChar
        End Select
    Next i
    
    intMax = UBound(udtNodes)
    For i = intMax To 0 Step -1
        If udtNodes(i).Use = False Then NodeList_Remove udtNodes(i).IP
    Next i

    NodeList_Display
End Sub

Sub Broadcast(strType As String, strIP As String, strName As String, strText As String)
    Dim i As Integer
    Dim intMax As Integer
    Dim strSend As String
    intMax = UBound(udtNodes)
    
    strSend = strType & DIV
    Add strSend, strIP & DIV
    Add strSend, strName & DIV
    Add strSend, strText
    
    
    With frmMain.wskChat
        If strType = MSG_ACK Then     'If you're replying to a login
            .RemoteHost = strText
            .SendData strSend
        Else
            For i = 0 To intMax
                .RemoteHost = udtNodes(i).IP
                .SendData strSend
            Next i
        End If
    End With
End Sub

Function HexCol(lngColor As Long) As String
    Dim strOut As String
    strOut = Hex(lngColor)
    strOut = String(6 - Len(strOut), "0") & strOut
    strOut = Right(strOut, 2) & Mid(strOut, 3, 2) & Left(strOut, 2)
    HexCol = RTF & COL & strOut
End Function

Function ValidName(strTestIt As String) As Boolean
    Dim intLen As Integer
    Dim i As Integer
    Dim intChar As Integer
    
    strTestIt = Trim(strTestIt)
    intLen = Len(strTestIt)
    
    If intLen = 0 Then Exit Function
    
    For i = 1 To intLen
        intChar = Asc(Mid(strTestIt, i, 1))
        If intChar < 33 Then Exit Function
        If intChar = 160 Then Exit Function
    Next i
        
    If NodeList_NameCollide(strTestIt) Then Exit Function
        
    ValidName = True
End Function

Sub GetColor(objLabel As Object)
    Dim lngColor As Long
    Dim intColorSum As Integer
    Dim blnGoodCol As Boolean
   
    With udtColor
        .hwndOwner = objLabel.Parent.hwnd
        .rgbResult = objLabel.ForeColor
        .lStructSize = Len(udtColor)
    End With
    
    Do
        If ShowColor(udtColor) Then
            lngColor = udtColor.rgbResult
        Else
            Exit Sub
        End If
        intColorSum = (lngColor And &HFF&) + ((lngColor And &HFF00&) / &H100&) + ((lngColor And &HFF0000) / &H10000)
        If intColorSum > 640 Then
            MsgBox "The color you selected is too light to be seen on a white background." & vbCrLf & "Please select a darker one.", vbExclamation, "Invalid Color"
        Else
            objLabel.ForeColor = lngColor
            Exit Sub
        End If
    Loop
End Sub

Sub Center(objNew As Object, objParent As Object)
    objNew.Left = ((objParent.Width - objNew.Width) / 2) + objParent.Left
    objNew.Top = ((objParent.Height - objNew.Height) / 2) + objParent.Top
End Sub
