Attribute VB_Name = "modFader"
Option Explicit
Private Declare Function SetWindowPos Lib "user32" (ByVal hWnd As Long, ByVal hWndINsertAfter As Long, ByVal X As Long, ByVal Y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long

Sub Main()
    Dim intX As Integer
    
    For intX = 0 To 5
        Call frmSetColor.UpdateColor(intX)
    Next intX
    
    Load frmOptions
    Load frmFader
    Load frmSetColor
    
    LoadFile
    
    frmFader.Show
    OnTop True
End Sub

Public Function CalcPart(intFrom As Integer, intTo As Integer, sngPct As Single) As Integer
    CalcPart = intFrom + ((intTo - intFrom) * sngPct)
End Function

Public Function MyHEX(bytDec As Byte) As String
    Dim strHex As String
    bytDec = Bar2Col(bytDec / 16)
    strHex = Hex(bytDec)
    strHex = String$(2 - Len(strHex), "0") + strHex
    MyHEX = strHex
End Function

Function DoFade(strIn As String)
    Dim intN As Integer
    Dim strOut As String
    Dim strCChr As String * 1
    Dim intStrInLen As Integer
    ReDim strHexCol(0 To Len(strIn)) As String * 6

    Dim intRed(0 To 6) As Integer
    Dim intGrn(0 To 6) As Integer
    Dim intBlu(0 To 6) As Integer

    Dim bytColNum As Byte
    Dim bytCCol As Byte
    Dim sngPrct As Single
    
    Dim strBadStuff As String
        
    intStrInLen = Len(strIn)
    bytColNum = frmSetColor.sldSetColNum - 1

    With frmSetColor
        For intN = 0 To bytColNum
            intRed(intN) = Bar2Col(.hsbRed(intN).Value)
            intGrn(intN) = Bar2Col(.hsbGrn(intN).Value)
            intBlu(intN) = Bar2Col(.hsbBlu(intN).Value)
        Next intN
    End With

    For intN = 1 To intStrInLen

        sngPrct = (intN * bytColNum) / Len(strIn)
        bytCCol = Int(sngPrct)
        sngPrct = sngPrct - bytCCol

        strHexCol(intN) = _
        MyHEX(CalcPart(intRed(bytCCol), intRed(bytCCol + 1), sngPrct)) + _
        MyHEX(CalcPart(intGrn(bytCCol), intGrn(bytCCol + 1), sngPrct)) + _
        MyHEX(CalcPart(intBlu(bytCCol), intBlu(bytCCol + 1), sngPrct))

    Next intN
    
    strBadStuff = vbCr + vbLf + Chr(32)
    
    For intN = 1 To intStrInLen
        strCChr = Mid(strIn, intN, 1)
        
        If (strHexCol(intN) = strHexCol(intN - 1)) Or InStr(strBadStuff, strCChr) <> 0 Then
            strOut = strOut + strCChr
        Else
            If intN > 1 And frmOptions.chkFontTags.Value = Checked Then strOut = strOut + "</FONT>"
            strOut = strOut + "<FONT COLOR=" + strHexCol(intN) + ">" + strCChr
        End If
        
    Next intN
    
    strOut = Replace(strOut, vbCrLf, "<BR>")
    
    With frmOptions
        If .chkFontTags.Value = Checked _
        Or .chkFinalFontTag.Value = Checked _
        Then strOut = strOut + "</FONT> "
    End With
    
    DoFade = strOut
End Function

Sub SaveFile()
    'Selected box
    'Number of colors
    '0 to 5
    '   red,green,blue
    'next
    'is window small?
    'use </FONT>
    'use final </FONT>
    'always on top
    
    
    Dim bytN As Byte
        
    Open "c:\paul248fader.ini" For Output As #1
        Print #1, Send2Index
        
        With frmSetColor
            Print #1, .sldSetColNum.Value
            
            For bytN = 0 To 5
                Print #1, .hsbRed(bytN).Value
                Print #1, .hsbGrn(bytN).Value
                Print #1, .hsbBlu(bytN).Value
            Next bytN
        End With
        
        Print #1, (frmFader.cmdInOut.Caption = Chr(52))
        
        With frmOptions
            Print #1, frmOptions.chkFontTags.Value
            Print #1, frmOptions.chkFinalFontTag.Value
            Print #1, frmOptions.chkOnTop.Value
        End With
    Close 1
End Sub

Sub LoadFile()
    Dim bytN As Integer
    Dim vntTemp As Variant

    On Error GoTo Errr
Back:
    Open "c:\paul248fader.ini" For Input As #1
        Input #1, vntTemp: frmOptions.optSend2.Item(vntTemp).Value = True
        
        With frmSetColor
            Input #1, vntTemp: .sldSetColNum.Value = vntTemp
                Call .sldSetColNum_Scroll
            
            For bytN = 0 To 5
                Input #1, vntTemp: .hsbRed(bytN).Value = vntTemp
                Input #1, vntTemp: .hsbGrn(bytN).Value = vntTemp
                Input #1, vntTemp: .hsbBlu(bytN).Value = vntTemp
            Next bytN
        End With
        
        Input #1, vntTemp: frmFader.cmdInOut.Value = vntTemp
       
        With frmOptions
            Input #1, vntTemp: .chkFontTags.Value = vntTemp
            Input #1, vntTemp: .chkFinalFontTag.Value = vntTemp
            Input #1, vntTemp: .chkOnTop.Value = vntTemp
        End With
        
    Close 1
    On Error GoTo 0
    Exit Sub

Errr:
    Close 1
    SaveFile
    GoTo Back
End Sub

Public Function Send2Index()
    Dim bytN As Byte
    For bytN = 0 To 1
        If frmOptions.optSend2(bytN).Value = True Then Send2Index = bytN
    Next bytN
End Function

Public Sub OnTop(blnTF As Boolean)
    Dim intWdw As Integer
    
    If blnTF = False Then intWdw = -2
    If blnTF = True Then intWdw = -1
    
    If frmOptions.chkOnTop = 0 Then intWdw = -2
    
    SetWindowPos frmFader.hWnd, intWdw, 0, 0, 0, 0, 3 'always on top
End Sub

Public Function Bar2Col(intVal As Integer) As Integer
    intVal = intVal * 16
    If intVal = 256 Then intVal = 255
    Bar2Col = intVal
End Function
