VERSION 5.00
Object = "{48E59290-9880-11CF-9754-00AA00C00908}#1.0#0"; "MSINET.OCX"
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Begin VB.Form frmMain 
   AutoRedraw      =   -1  'True
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "ExTemp Configuration"
   ClientHeight    =   1410
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4320
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   94
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   288
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Visible         =   0   'False
   Begin VB.Timer tmrCheck 
      Interval        =   1000
      Left            =   3120
      Top             =   1800
   End
   Begin VB.CommandButton cmdAbout 
      Caption         =   "&About"
      Height          =   375
      Left            =   1560
      TabIndex        =   3
      Top             =   840
      Width           =   1215
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   375
      Left            =   2880
      TabIndex        =   4
      Top             =   840
      Width           =   1215
   End
   Begin VB.CommandButton cmdOk 
      Caption         =   "&Ok"
      Default         =   -1  'True
      Height          =   375
      Left            =   240
      TabIndex        =   2
      Top             =   840
      Width           =   1215
   End
   Begin VB.PictureBox picNumbers 
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   120
      Left            =   600
      Picture         =   "frmMain.frx":0442
      ScaleHeight     =   120
      ScaleWidth      =   660
      TabIndex        =   6
      Top             =   2040
      Visible         =   0   'False
      Width           =   660
   End
   Begin VB.PictureBox picIcon 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00000000&
      BorderStyle     =   0  'None
      Height          =   240
      Left            =   960
      ScaleHeight     =   16
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   16
      TabIndex        =   5
      Top             =   2280
      Visible         =   0   'False
      Width           =   240
   End
   Begin VB.TextBox txtZip 
      Alignment       =   2  'Center
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Left            =   1080
      MaxLength       =   5
      TabIndex        =   1
      Text            =   "88888"
      Top             =   240
      Width           =   855
   End
   Begin InetCtlsObjects.Inet Inet 
      Left            =   1440
      Top             =   2040
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      URL             =   "http://"
   End
   Begin VB.Label lblZip 
      AutoSize        =   -1  'True
      Caption         =   "&ZIP Code:"
      Height          =   195
      Left            =   240
      TabIndex        =   0
      Top             =   360
      Width           =   720
   End
   Begin ComctlLib.ImageList ImageList 
      Left            =   2040
      Top             =   2040
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      MaskColor       =   12632256
      _Version        =   327682
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim intTime As Integer
Dim strZip As String
Dim strLocation As String
Dim intTemp As Integer
Dim enmFail As FailEnum

Private Sub cmdAbout_Click()
    frmAbout.Show 1
End Sub

Private Sub cmdExit_Click()
    Shell_NotifyIcon NIM_DELETE, IconData
    End
End Sub

Sub GenerateIcon()
    Dim intBar As Integer
    Dim intDig(0 To 2) As Integer
    Dim intDigits As Integer
    Dim intXLoc As Integer
    Dim i As Integer
    
    picIcon.Cls
    
    Select Case enmFail
        Case Initial
            IconData.szTip = "Temperature not yet determined." & Chr(0)
        Case Unexpected
            IconData.szTip = "The server returned unexpected data." & Chr(0)
        Case BadZip
            IconData.szTip = "Your ZIP code was not found." & Chr(0)
        Case NoConnect
            IconData.szTip = "Unable to connect to server." & Chr(0)
        Case Good
            IconData.szTip = intTemp & Chr(176) & "F" & " - " & strLocation & Chr(0)
    End Select
    
    If enmFail = Unexpected Or enmFail = BadZip Then
        picIcon.Line (0, 0)-(15, 15), vbRed
        picIcon.Line (0, 15)-(15, 0), vbRed
    Else
        picIcon.Line (1, 1)-(14, 5), vbWhite, B
        
        If intTemp < -99 Then intTemp = -99
        If intTemp > 199 Then intTemp = 199
        If enmFail = Initial Then intTemp = -100
        
        intBar = (intTemp + 10) \ 10
        If intBar > 12 Then intBar = 12
    
        If intBar > 0 Then picIcon.Line (2, 2)-(1 + intBar, 4), vbRed, BF
        
        Select Case intTemp
            Case -100   'Initial Value
                intDigits = 2
                intDig(0) = -1
                intDig(1) = -1
            Case -99 To -10
                intDigits = 3
                intDig(0) = -1
                intDig(1) = -intTemp \ 10
                intDig(2) = -intTemp Mod 10
            Case -9 To -1
                intDigits = 2
                intDig(0) = -1
                intDig(1) = -intTemp
            Case 0 To 9
                intDigits = 1
                intDig(0) = intTemp
            Case 10 To 99
                intDigits = 2
                intDig(0) = intTemp \ 10
                intDig(1) = intTemp Mod 10
            Case Is >= 100
                intDigits = 3
                intDig(0) = 1
                intDig(1) = (intTemp - 100) \ 10
                intDig(2) = intTemp Mod 10
        End Select
       
        intXLoc = 9 - intDigits * 3
        
        For i = 0 To intDigits - 1
            BitBlt picIcon.hDC, intXLoc, 7, 4, 8, picNumbers.hDC, (intDig(i) + 1) * 4, 0, SRCCOPY
            intXLoc = intXLoc + 5
        Next i
        picIcon.PSet (intXLoc, 7), vbYellow
    End If
    
    ImageList.ListImages.Clear
    ImageList.ListImages.Add , , picIcon.Image
    IconData.hIcon = ImageList.ListImages(1).ExtractIcon
End Sub

Private Sub cmdOK_Click()
    strZip = txtZip.Text
    SaveSetting "Paul248", "ExTemp", "ZIPCode", strZip
    Me.Hide
    DownloadAndUpdate
End Sub

Private Sub Form_Load()
    App.TaskVisible = False
    strZip = GetSetting("Paul248", "ExTemp", "ZIPCode", "")
    If strZip = "" Then ShowForm
    enmFail = Initial
    
    With IconData
        .cbSize = Len(IconData) ' The length of the NOTIFYICONDATA type
        .hwnd = Me.hwnd ' hWnd of the form
        .uCallbackMessage = WM_MOUSEMOVE ' The icon we're placing will send messages to the MouseMove event
        .uFlags = NIF_ICON Or NIF_TIP Or NIF_MESSAGE ' It will have message handling and a tooltip
        .uID = vbNull ' uID is not used by VB, so it's set to a Null value
    End With
    
    GenerateIcon
    Shell_NotifyIcon NIM_ADD, IconData
    
    DownloadAndUpdate
End Sub

Private Sub Form_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If X = WM_LBUTTONDBLCLK Then ShowForm
End Sub

Sub ShowForm()
    txtZip.Text = strZip
    Me.Show
    txtZip.SetFocus
    txtZip_GotFocus
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Cancel = 1
    Me.Hide
End Sub

Private Sub tmrCheck_Timer()
    intTime = intTime + 1
    If intTime >= 600 Then DownloadAndUpdate
End Sub

Sub DownloadAndUpdate()
    intTime = 0
    
    Dim i As Integer

    Dim strNewTemp As String
    Dim strNewLoc As String
    
    If Inet.StillExecuting Then Exit Sub
    On Error GoTo ErrorTrap
    strNewTemp = Inet.OpenURL("http://wwwa.accuweather.com/forecast-current-conditions.asp?zipcode=" & strZip)
    On Error GoTo 0
ErrorTrap:

    strNewLoc = strNewTemp
    
    If strNewTemp = "" Then
        If enmFail <> Initial Then enmFail = NoConnect
    ElseIf InStr(strNewTemp, ".com - ,  Current") <> 0 Then
        enmFail = BadZip
    Else
        TrimLeft strNewTemp, "cTmp="
        TrimRight strNewTemp, """;"
        
        TrimLeft strNewLoc, ".com - "
        TrimRight strNewLoc, " Current"
'        strNewLoc = Replace(Replace(strNewLoc, vbCr, ""), vbLf, "") ' clear out the linefeed before the location
              
        If strNewTemp = "" Or strNewLoc = "" Then
            enmFail = Unexpected
        Else
            strLocation = strNewLoc
            intTemp = Val(strNewTemp)
            enmFail = Good
        End If
    End If

    GenerateIcon
    Shell_NotifyIcon NIM_MODIFY, IconData
End Sub

Private Sub txtZip_Change()
    Dim i As Integer
    Dim blnEnable As Boolean
    blnEnable = True
    If Len(txtZip.Text) <> 5 Then blnEnable = False
    For i = 1 To Len(txtZip.Text)
        Select Case Mid(txtZip.Text, i, 1)
            Case "0" To "9"
            Case Else
                blnEnable = False
        End Select
    Next i
    cmdOk.Enabled = blnEnable
End Sub

Private Sub txtZip_GotFocus()
    txtZip.SelStart = 0
    txtZip.SelLength = Len(txtZip.Text)
End Sub
