Attribute VB_Name = "modCode"
Option Explicit
Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Long) As Long
Declare Function DefWindowProc Lib "user32" Alias "DefWindowProcA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long

Public strExtIP As String

Public Type ChannelInfoStruc
    Enabled As Boolean  'True when the channel exists
    Monitor As Boolean  'True = Inspect packets / False = relay raw data
    BufferIn As String  'Stores data from the client
    BufferOut As String 'Stores data from the server
End Type

Public Type ServiceListenStruc
    Monitor As Boolean  'If true, channels created from this port will be monitored
    Host As String
    Port As Long
End Type

Public lngRepPort As Long

Public ChanInfo(1 To 256) As ChannelInfoStruc  'keeps information about the channels
Public ListenInfo(0 To 4) As ServiceListenStruc 'stores info on listening ports
Public intListenIndex As Integer 'Index of the next socket index to accept stuff on (goes from 1 to 4 and back again)

Public Function BufNum(strBuffer As String, lngIndex As Long, Optional intLen As Long = 1) As Long
    Dim i As Long
    Dim lngOut As Long
    For i = lngIndex To lngIndex + intLen - 1
        lngOut = lngOut * 256
        lngOut = lngOut + Asc(Mid(strBuffer, i, 1))
    Next i
    BufNum = lngOut
End Function

Public Function NumToStr(lngNum As Long, intLen As Integer) As String
    Dim strOut As String
    Dim lngNum2 As Long
    Dim i As Integer
    
    lngNum2 = lngNum
    
    For i = 1 To intLen
        strOut = Chr(lngNum2 And &HFF) & strOut
        lngNum2 = lngNum2 \ &H100
    Next i
    NumToStr = strOut
End Function

Public Function BufCut(strBuffer, lngLength As Long) As String
    BufCut = Left(strBuffer, lngLength)
    strBuffer = Mid(strBuffer, lngLength + 1)
End Function

Public Function MatchPacket(strPacket As String, lngChannel As Long, lngFamily As Long, lngSubType As Long) As Boolean
    MatchPacket = False
    If Len(strPacket) > 16 Then
        If BufNum(strPacket, 1) = &H2A Then
            If BufNum(strPacket, 2) = lngChannel Then
                If BufNum(strPacket, 7, 2) = lngFamily Then
                    If BufNum(strPacket, 9, 2) = lngSubType Then
                        MatchPacket = True
                    End If
                End If
            End If
        End If
    End If
End Function

Function GetFLAP(strBuffer As String, strPacket As String, lngPacketSize As Long) As Boolean
    'removes the next FLAP packet from the beginning of the buffer
    'and places it into strPacket.  If there's not a whole FLAP available,
    'the function returns False, and strOutput is unchanged.
    'lngSize will be the length of the packet, including the header
    
    If Len(strBuffer) < 6 Then
        GetFLAP = False
        Exit Function
    End If
    
    lngPacketSize = BufNum(strBuffer, 5, 2) + 6
    If Len(strBuffer) < lngPacketSize Then
        GetFLAP = False
        Exit Function
    End If
    
    strPacket = Left(strBuffer, lngPacketSize)
    strBuffer = Mid(strBuffer, lngPacketSize + 1)
    GetFLAP = True
End Function

Sub NextTLV(strPacket As String, lngPos As Long)
    'when lngPos is the index of the start of a TLV, this
    'sub will move lngPos to the data right after it.
    lngPos = lngPos + BufNum(strPacket, lngPos + 2, 2) + 4
End Sub

Sub ShowInCenter(frmParent As Form, frmPopup As Form)
    frmPopup.Left = frmParent.Left + (frmParent.Width - frmPopup.Width) / 2
    frmPopup.Top = frmParent.Top + (frmParent.Height - frmPopup.Height) / 2
    frmPopup.Show 1
End Sub

