VERSION 5.00
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "AIM FixDC v1.3"
   ClientHeight    =   3375
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4245
   Icon            =   "frmMain.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   225
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   283
   StartUpPosition =   3  'Windows Default
   Visible         =   0   'False
   Begin MSWinsockLib.Winsock wskAccept 
      Index           =   0
      Left            =   1920
      Top             =   840
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin VB.CommandButton cmdClear 
      Caption         =   "&Clear Log"
      Height          =   375
      Left            =   120
      TabIndex        =   2
      Top             =   2040
      Width           =   1935
   End
   Begin VB.CommandButton cmdHelp 
      Caption         =   "View &Instructions"
      Height          =   375
      Left            =   2160
      TabIndex        =   3
      Top             =   2040
      Width           =   1935
   End
   Begin MSWinsockLib.Winsock wskOut 
      Index           =   0
      Left            =   2880
      Top             =   840
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin MSWinsockLib.Winsock wskIn 
      Index           =   0
      Left            =   2400
      Top             =   840
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin VB.ListBox lstLog 
      Height          =   1620
      Left            =   120
      TabIndex        =   1
      Top             =   360
      Width           =   3975
   End
   Begin VB.Image imgTray 
      Height          =   240
      Left            =   120
      Picture         =   "frmMain.frx":0442
      Top             =   2520
      Visible         =   0   'False
      Width           =   240
   End
   Begin VB.Label lblRepPort 
      Alignment       =   2  'Center
      BorderStyle     =   1  'Fixed Single
      Caption         =   "00000"
      Height          =   255
      Left            =   3480
      TabIndex        =   5
      ToolTipText     =   "Click to Change"
      Top             =   2520
      Width           =   615
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Created by Paul Marks"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000000&
      Height          =   240
      Left            =   120
      MouseIcon       =   "frmMain.frx":058C
      TabIndex        =   7
      Top             =   3000
      Width           =   1995
   End
   Begin VB.Label lblUrl 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "http://paul248.tk"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   -1  'True
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FF0000&
      Height          =   240
      Left            =   2685
      MouseIcon       =   "frmMain.frx":0896
      MousePointer    =   99  'Custom
      TabIndex        =   6
      Top             =   3000
      Width           =   1410
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "&Log:"
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   315
   End
   Begin VB.Label Label4 
      Caption         =   "Replace Port:  4443 ->"
      Height          =   255
      Left            =   1830
      TabIndex        =   4
      Top             =   2550
      Width           =   1935
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Sub AddLog(strText As String)
    lstLog.AddItem strText
    Do While lstLog.ListCount > 50
        lstLog.RemoveItem 0
    Loop
    lstLog.ListIndex = lstLog.ListCount - 1
End Sub

Sub ToTray()
    Hide
    Shell_NotifyIcon NIM_ADD, IconData
End Sub

Sub FromTray()
    WindowState = vbNormal
    Show
    Shell_NotifyIcon NIM_DELETE, IconData
End Sub

Function NewListen(strAddr As String, blnMonitor As Boolean) As String
    'Assigns a remote "Host:Port" to one of the listening sockets.
    'There are only 4 sockets because the chances of getting 4 sequential
    'requests is very slim, and the consequences of a collision aren't too fatal.
    'Returns the local ip/port for aim to connect to
    
    Dim intPos As Integer
    intPos = InStr(strAddr, ":")
    With ListenInfo(intListenIndex)
        If intPos = 0 Then
            .Host = strAddr
            .Port = 5190
        Else
            .Host = Left(strAddr, intPos - 1)
            .Port = Val(Mid(strAddr, intPos + 1))
        End If
        .Monitor = blnMonitor
    End With
    
    NewListen = "127.0.0.1:" & wskAccept(intListenIndex).LocalPort
    
    intListenIndex = intListenIndex + 1
    If intListenIndex > 4 Then intListenIndex = 1
End Function

Sub KillChannel(intIndex As Integer)
    With ChanInfo(intIndex)
        .Enabled = False
        .BufferIn = ""
        .BufferOut = ""
    End With
    Unload wskIn(intIndex)
    Unload wskOut(intIndex)
    AddLog "Channel #" & intIndex & " Terminated"
End Sub

Private Sub cmdClear_Click()
    If MsgBox("Are you sure you want to clear the log?", vbQuestion + vbYesNo, "Clear Log") = vbYes Then
        lstLog.Clear
    End If
End Sub

Private Sub cmdHelp_Click()
    frmHelp.Show 1
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
    MsgBox KeyAscii
End Sub

Private Sub Form_Load()
    Dim i As Integer
    
    App.TaskVisible = False
    
    lngRepPort = GetSetting("Paul248", "AimFixDC", "ReplacePort", 4443)
    lblRepPort.Caption = lngRepPort
    
    With IconData
        .cbSize = Len(IconData) ' The length of the NOTIFYICONDATA type
        .hwnd = Me.hwnd ' hWnd of the form
        .uCallbackMessage = WM_MOUSEMOVE ' The icon we're placing will send messages to the MouseMove event
        .uFlags = NIF_ICON Or NIF_TIP Or NIF_MESSAGE ' It will have message handling and a tooltip
        .uID = vbNull ' uID is not used by VB, so it's set to a Null value
        .hIcon = imgTray.Picture
        .szTip = "AIM FixDC" & Chr(0)
    End With
    
    'Socket 0 is for the Login server
    'Sockets 1-4 are used in sequence for any other services
    
    With ListenInfo(0)
        .Monitor = True
        .Host = "login.oscar.aol.com"
        .Port = 5190
    End With
    intListenIndex = 1
    
    For i = 1 To 4
        'load up the next 4 sockets
        Load wskAccept(i)
    Next i
    
    For i = 0 To 4
        wskAccept(i).LocalPort = 51900 + i  ' use ports 51900-51904
        wskAccept(i).Listen
    Next i
    
    AddLog "Sockets Listening"
    
    ToTray
End Sub

Private Sub Form_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If X = WM_LBUTTONDBLCLK Then FromTray
End Sub

Private Sub Form_Resize()
    If WindowState = vbMinimized Then ToTray
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Shell_NotifyIcon NIM_DELETE, IconData
End Sub

Private Sub lblRepPort_Click()
    ShowInCenter Me, frmPort
    lblRepPort.Caption = lngRepPort
End Sub

Private Sub lblUrl_Click()
    ShellExecute 0&, vbNullString, "http://paul248.tk/", vbNullString, "C:\", 1
End Sub

Private Sub wskAccept_ConnectionRequest(Index As Integer, ByVal requestID As Long)
    Dim intChan As Integer
    
    If wskAccept(Index).RemoteHostIP = "127.0.0.1" And ListenInfo(Index).Host <> "" Then
        'Look for an unused channel
        intChan = 1
        Do While ChanInfo(intChan).Enabled
            intChan = intChan + 1
        Loop
        
        With ChanInfo(intChan)
            .Enabled = True
            .Monitor = ListenInfo(Index).Monitor   'if Monitor is true, then each packet will be inspected
            .BufferIn = ""
            .BufferOut = ""
        End With
        
        Load wskIn(intChan)
        Load wskOut(intChan)

        wskOut(intChan).Connect ListenInfo(Index).Host, ListenInfo(Index).Port
        Do
            If ChanInfo(intChan).Enabled Then
                If wskOut(intChan).State = sckConnected Then
                    wskIn(intChan).Accept requestID
                    AddLog "Channel #" & intChan & " Created"
                    Exit Sub
                End If
                DoEvents
            Else
                AddLog "Channel #" & intChan & " Init Failed"
                wskAccept(Index).Close
                wskAccept(Index).Listen
                Exit Sub
            End If
        Loop
    Else
        wskAccept(Index).Close
        wskAccept(Index).Listen
    End If

End Sub

Private Sub wskIn_Close(Index As Integer)
    KillChannel Index
End Sub

Private Sub wskIn_Error(Index As Integer, ByVal Number As Integer, Description As String, ByVal Scode As Long, ByVal Source As String, ByVal HelpFile As String, ByVal HelpContext As Long, CancelDisplay As Boolean)
    KillChannel Index
End Sub

Private Sub wskOut_Close(Index As Integer)
    KillChannel Index
End Sub

Private Sub wskOut_Error(Index As Integer, ByVal Number As Integer, Description As String, ByVal Scode As Long, ByVal Source As String, ByVal HelpFile As String, ByVal HelpContext As Long, CancelDisplay As Boolean)
    KillChannel Index
End Sub

Private Sub wskIn_DataArrival(Index As Integer, ByVal bytesTotal As Long)
    Dim strPacket As String
    Dim lngPacketSize As Long
    Dim lngPos As Long
    Dim lngCurPort As Long
    
    wskIn(Index).GetData strPacket
    
    If ChanInfo(Index).Monitor Then
        
        ChanInfo(Index).BufferIn = ChanInfo(Index).BufferIn & strPacket
        
        Do While GetFLAP(ChanInfo(Index).BufferIn, strPacket, lngPacketSize)
            If strExtIP <> "" And MatchPacket(strPacket, &H2, &H4, &H6) Then
                If lngPacketSize > 58 Then
                    'Make sure this is a Rendezvous packet
                    If BufNum(strPacket, 25, 2) = &H2 Then
                        lngPos = 28 + BufNum(strPacket, 27) + 14 + 16 'skip over screen name and other data
                        Do While lngPos <= lngPacketSize
                            If BufNum(strPacket, lngPos, 4) = &H30004 Then   '0x0003, 0x0004 = IP Address
                                Mid(strPacket, lngPos + 4, 4) = strExtIP
                            End If
                            If BufNum(strPacket, lngPos, 4) = &H50002 Then   '0x0005, 0x0002 = Port
                                lngCurPort = BufNum(strPacket, lngPos + 4, 2)
                                If lngCurPort <> 4443 Or lngRepPort = 4443 Then
                                    AddLog "Direct Connect Requested on Port " & lngCurPort
                                Else
                                    Mid(strPacket, lngPos + 4, 2) = NumToStr(lngRepPort, 2)
                                    AddLog "DC Requested on Port 4443 (Changed to " & lngRepPort & ")"
                                End If
                            End If
                            NextTLV strPacket, lngPos
                        Loop
                    End If
                End If
            End If
            SendData_ErrorTrap wskOut(Index), strPacket
        Loop
    Else
        SendData_ErrorTrap wskOut(Index), strPacket    'if monitor=false, just relay data
    End If
    
    Exit Sub
End Sub

Private Sub wskOut_DataArrival(Index As Integer, ByVal bytesTotal As Long)
    Dim strPacket As String
    Dim lngPacketSize As Long
    Dim lngPos As Long
    Dim strOldAddr As String
    Dim strNewAddr As String
    
    wskOut(Index).GetData strPacket
    
    If ChanInfo(Index).Monitor Then
        ChanInfo(Index).BufferOut = ChanInfo(Index).BufferOut & strPacket
        
        Do While GetFLAP(ChanInfo(Index).BufferOut, strPacket, lngPacketSize)
            If MatchPacket(strPacket, &H2, &H17, &H3) Then
                lngPos = 17     'first byte after FLAP and SNAC headers
                Do While lngPos <= Len(strPacket)
                    If BufNum(strPacket, lngPos, 2) = &H5 Then  '0x0005 = Server IP
                        
                        strOldAddr = Mid(strPacket, lngPos + 4, BufNum(strPacket, lngPos + 2, 2))
                        strNewAddr = NewListen(strOldAddr, True)
                        
                        'Replace some stuff so that AIM connects to localhost instead of direct to the server
                        strPacket = Left(strPacket, lngPos + 1) & NumToStr(Len(strNewAddr), 2) & strNewAddr & Mid(strPacket, lngPos + 4 + Len(strOldAddr))
                        
                        'Update SNAC with new length
                        Mid(strPacket, 5, 2) = NumToStr(BufNum(strPacket, 5, 2) - Len(strOldAddr) + Len(strNewAddr), 2)
                        
                        AddLog "Redirecting to BOS Server"
                    End If
                    NextTLV strPacket, lngPos
                Loop
            End If
            
            If MatchPacket(strPacket, &H2, &H1, &H5) Then
                lngPos = 17 + 8   'first byte after FLAP and SNAC headers, and 8 weird bytes (?)
                Do While lngPos <= Len(strPacket)
                    If BufNum(strPacket, lngPos, 2) = &H5 Then  '0x0005 = server IP
                        strOldAddr = Mid(strPacket, lngPos + 4, BufNum(strPacket, lngPos + 2, 2))
                        strNewAddr = NewListen(strOldAddr, False)
                                                           
                        'Make AIM Connect to localhost instead of direct to Chat/Ad server
                        strPacket = Left(strPacket, lngPos + 1) & NumToStr(Len(strNewAddr), 2) & strNewAddr & Mid(strPacket, lngPos + 4 + Len(strOldAddr))

                        'Update SNAC with new length
                        Mid(strPacket, 5, 2) = NumToStr(BufNum(strPacket, 5, 2) - Len(strOldAddr) + Len(strNewAddr), 2)
                        
                        AddLog "Incoming New Service Request"
                    End If
                    NextTLV strPacket, lngPos
                Loop
            End If
            
            If MatchPacket(strPacket, &H2, &H1, &HF) Then
                If Len(strPacket) > 17 Then
                    lngPos = 18 + BufNum(strPacket, 17) + 4   'skip over screen name, etc. to the TLV's
                    Do While lngPos <= lngPacketSize
                        If BufNum(strPacket, lngPos, 4) = &HA0004 Then ' 0x000A, 0x0004 = External IP address (length=4)
                            'Save External IP Address when the server sends it
                            strExtIP = Mid(strPacket, lngPos + 4, 4)
                            AddLog "Determined IP Address: " & Asc(Mid(strExtIP, 1, 1)) & "." & Asc(Mid(strExtIP, 2, 1)) & "." & Asc(Mid(strExtIP, 3, 1)) & "." & Asc(Mid(strExtIP, 4, 1))
                        End If
                        NextTLV strPacket, lngPos
                    Loop
                End If
            End If
            SendData_ErrorTrap wskIn(Index), strPacket
        Loop
    Else
        SendData_ErrorTrap wskIn(Index), strPacket    'Unmonitored channel, just relay the data
    End If
    
    Exit Sub
End Sub

Sub SendData_ErrorTrap(wskIO As Winsock, strData As String)
    ' This is to correct some random errors that happened when something
    ' went wrong.  If an error occurs while sending, I'll just kill the channel
    
    On Error GoTo ErrorTrap
    wskIO.SendData strData
    Exit Sub

ErrorTrap:
    KillChannel wskIO.Index
End Sub
